#!/usr/bin/env ruby

require 'rubygems'
require 'RMagick'

Directory = '/Users/d/Desktop/illusion'
Name = 'pentagon'

frames = Magick::ImageList.new(*Dir["#{Directory}/#{Name}/*.png"])
illusion = Magick::Image.new(frames.first.columns, frames.first.rows)

module Magick
  class Image
    attr_accessor :col_img
    def composite_column!(img, col, mycol)
      @col_img ||= Image.new(1, img.rows)
      @col_img.composite! img, -col, 0, ReplaceCompositeOp
      composite! @col_img, mycol, 0, ReplaceCompositeOp
    end
  end
end

(0...frames.first.columns).each do |col|
  cur = frames[col % frames.count]
  illusion.composite_column! cur, col, col
end

illusion.write("#{Directory}/#{Name}-illusion.png")

# make the viewer as well, why not

viewer = Magick::Image.new(illusion.columns, illusion.rows) {
  self.background_color = '#0000' }

gc = Magick::Draw.new { self.fill = '#111' }
(viewer.columns / frames.count + 1).times do |n|
  gc.rectangle(n * frames.count, 0,
               (n + 1) * frames.count - 2, viewer.rows)
end
gc.draw viewer

viewer.write("#{Directory}/#{Name}-mask.png")
